
;- Initialisation
If InitEngine3D() = 0
  MessageRequester( "Error" , "Can't initialize 3D, check if engine3D.dll is available" , 0 )
  End
ElseIf InitSprite() = 0 Or InitKeyboard() = 0
  MessageRequester( "Error" , "Can't find DirectX 7.0 or above" , 0 )
  End
EndIf

result = MessageRequester("Normal Maps","Full Screen ?",#PB_MessageRequester_YesNo)
If result = 6     
  FullScreen=#True
  OpenScreen(1024,768,32,"Normal Maps")
Else           
  FullScreen=#False
  OpenWindow(0,0, 0, 800 , 600 ,"Normal Maps",#PB_Window_ScreenCentered)
  OpenWindowedScreen(WindowID(0),0,0, 800 , 600,0,0,0)
EndIf

;- Ressources
Add3DArchive("shaders\", #PB_3DArchive_FileSystem  )
Add3DArchive("textures\", #PB_3DArchive_FileSystem  )
Add3DArchive("meshes\", #PB_3DArchive_FileSystem  )
Add3DArchive("materials\", #PB_3DArchive_FileSystem  )

WorldShadows(#PB_Shadow_Modulative)

;- Crer un sol
nummesh = CreateMesh(#PB_Any,100)
SetMeshData(nummesh, #PB_Mesh_Vertex | #PB_Mesh_Normal | #PB_Mesh_UVCoordinate, ?PlanVertices, 4)
SetMeshData(nummesh, #PB_Mesh_Face, ?PlanFaces, 2)

numEntity = CreateEntity(#PB_Any,MeshID(numMesh),#PB_Material_None)
ScaleEntity(numEntity,100,100,1)
RotateEntity(numEntity,90,0,0)
EntityLocate(numEntity,0,-5,0)


;- Crer un plain pour figurer l'emplacement de la lumire
nummesh = CreateMesh(#PB_Any,100)
SetMeshData(nummesh, #PB_Mesh_Vertex | #PB_Mesh_Normal | #PB_Mesh_UVCoordinate, ?PlanVertices, 4)
SetMeshData(nummesh, #PB_Mesh_Face, ?PlanFaces, 2)


CreateEntity(999,MeshID(numMesh),#PB_Material_None)
EntityRenderMode(999,0)


;- Crer les cubes
Parse3DScripts()
LoadMesh   (1 , "cube.mesh")

CreateEntity(1,   MeshID(1),  #PB_Material_None,-20,0,0)
ScaleEntity(1,10,10,10)
EntityRenderMode(1,#PB_Entity_CastShadow)
CreateEntity(2,   MeshID(1),  #PB_Material_None,20,0,0)
ScaleEntity(2,10,10,10)
CreateEntity(3,MeshID(1),  #PB_Material_None)
ScaleEntity(3,20,20,20)
EntityLocate(3,0,5,0)
RotateEntity(3,0,45,0)

;- Lights
AmbientColor($555555)  
CreateLight(0, $FFFFFF)


;- Camera
CreateCamera(0, 0,0,100,100)
CameraBackColor(0,$AA7755)
CameraLocate(0, 0, 50, -50)
CameraLookAt(0, 0 , 0, 0)

Repeat

  If FullScreen = #False
    While WindowEvent():Wend
  EndIf
  ExamineKeyboard()
                
  i.f-0.009  
  
  LightLocate(0,30*Cos(i),20,30*Sin(i))
  EntityLocate(999,30*Cos(i),20,30*Sin(i))
  RotateEntity(999,0,0,80,#PB_Relative)
  
  RenderWorld()
  FlipBuffers()

  Until KeyboardPushed(#PB_Key_Escape)

End

;- data Section
DataSection

  PlanVertices:
  Data.f -0.5, -0.5, 0.0
  Data.f 1, 1, 1
  Data.f 0, 1
  Data.f 0.5, -0.5, 0.0
  Data.f 1,1,1
  Data.f 1, 1
  Data.f 0.5, 0.5, 0.0
  Data.f 1,1,1
  Data.f 1, 0
  Data.f -0.5, 0.5, 0.0
  Data.f 1,1,1
  Data.f 0,0
 
  PlanFaces:
  Data.w 2, 1, 0
  Data.w 0, 3, 2

EndDataSection 
; IDE Options = PureBasic 4.41 (Windows - x86)
; CursorPosition = 44
; FirstLine = 35
; Executable = C:\0\fire.exe
; DisableDebugger