
#SCREENWIDTH = 800
#SCREENHEIGHT = 500
#CameraSpeed = 0.5

#LEFTCAM = 0
#RIGHTCAM = 1
#EYES_DISTANCE = 0.05

Global  MouseX.f, MouseY.f, moveTimer1.f, moveTimer2.f = 0

;- Initialisation
If InitEngine3D(#PB_Engine3D_EnableCG|#PB_Engine3D_DebugLog) = 0
  MessageRequester( "Error" , "Can't initialize 3D, check if engine3D.dll is available" , 0 )
  End
ElseIf InitSprite() = 0 Or InitKeyboard() = 0 Or InitMouse()=0
  MessageRequester( "Error" , "Can't initialize Screen, mouse or keyboard" , 0 )
  End
EndIf

OpenWindow(0,0, 0, #SCREENWIDTH , #SCREENHEIGHT,"Anaglyph Compositor",#PB_Window_ScreenCentered)
OpenWindowedScreen(WindowID(0), 0, 0, #SCREENWIDTH,#SCREENHEIGHT, 0, 0, 0,#PB_Screen_SmartSynchronization)


;- Ressources
Add3DArchive("compositors\", #PB_3DArchive_FileSystem  )
Add3DArchive("shaders\", #PB_3DArchive_FileSystem  )
Add3DArchive("textures\", #PB_3DArchive_FileSystem  )
Add3DArchive("meshes\", #PB_3DArchive_FileSystem  )
Add3DArchive("materials\", #PB_3DArchive_FileSystem  )
Parse3DScripts()


;- Scene
; Background
tileTex = LoadTexture(#PB_Any,"tile.jpg")
tileMat = CreateMaterial(#PB_Any,TextureID(tileTex)) 
wallTex = LoadTexture(#PB_Any,"Ogre-logo.png")
wallMat = CreateMaterial(#PB_Any,TextureID(wallTex)) 

; Ground and wall
flatMesh = CreatePlane(#PB_Any,20,20,10,10,5,5)
ground = CreateEntity(#PB_Any,MeshID(flatMesh),MaterialID(tileMat))
MoveEntity(ground,0,0,0, #PB_Absolute)

wallMesh = CreatePlane(#PB_Any,20,10,10,10,4,2)
wall = CreateEntity(#PB_Any,MeshID(wallMesh),MaterialID(wallMat))
RotateEntity(wall,90,180,0,#PB_Absolute)
MoveEntity(wall,0,5,-10, #PB_Absolute)

; Cube
cubeMesh = CreateCube(#PB_Any,1)
numMaterial = GetScriptMaterial(#PB_Any,"Caisse")
cube = CreateEntity(#PB_Any, MeshID(cubeMesh), MaterialID(numMaterial) )


;- Lights
AmbientColor($555555)  
CreateLight(0, $FFFFFF, 20,50,50)
LightAttenuation(0, 750, 0)
WorldShadows(#PB_Shadow_Additive)


;- Cameras
CreateCamera(#LEFTCAM, 0,0,100,100)
CameraBackColor(#LEFTCAM,0)
MoveCamera(#LEFTCAM, -#EYES_DISTANCE, 0, 0,#PB_Absolute)

CreateCamera(#RIGHTCAM, 0,0,100,100)
CameraBackColor(#RIGHTCAM,0)
MoveCamera(#RIGHTCAM, #EYES_DISTANCE, 0, 0,#PB_Absolute)

; Both cameras (the eyes) are attached to a node (the head)
camNode = CreateNode(#PB_Any,0,0,0)
AttachNodeObject(camNode,CameraID(#LEFTCAM))
AttachNodeObject(camNode,CameraID(#RIGHTCAM))

MoveNode(camNode,0,2,5)
CameraLookAt(#LEFTCAM, 0 , 2, 0)
CameraLookAt(#RIGHTCAM, 0 , 2, 0)

; The view from the "right-eye" camera is rendered to a texture.
; The last param (Ogre name) is used so the render texture can be used in the material script.
rightEyeTex = CreateRenderTexture(#PB_Any,CameraID(#RIGHTCAM),#SCREENWIDTH,#SCREENHEIGHT,#PB_Texture_AutomaticUpdate,"rightEye")


;- Compositor
; This full-screen compositor renders the scene from the "left-eye" camera to a texture, 
; then calls a material which passes the "left-eye" and "right-eye" textures to a shader.
; The shader merges the red from one cam and green & blue from the other to get the final result.
CreateCompositorEffect(0, CameraID(0), "stereoscopy")


;- Main loop
Repeat
  While WindowEvent(): Wend
  ExamineKeyboard()
  
  
  ; Cameras movement
  If ExamineMouse()
    MouseX = -MouseDeltaX() * #CameraSpeed
    MouseY = -MouseDeltaY() * #CameraSpeed
  EndIf 
  RotateNode(camNode, MouseY, MouseX, 0, #PB_Relative)
  
  ; Cube movements
  RotateEntity(cube,0.5,0.2,0.3, #PB_Relative)
  moveTimer1 + 0.005
  moveTimer2 + 0.007
  MoveEntity(cube,3 * Cos(moveTimer1),2,-3 + 5 * Sin(moveTimer2),#PB_Absolute)
  
  ; Render scene
  RenderWorld()
  FlipBuffers()
  
Until KeyboardPushed(#PB_Key_Escape) Or Quit = 1


End
; IDE Options = PureBasic 5.11 (Windows - x86)
; CursorPosition = 58
; FirstLine = 21
; EnableXP