
;- Initialisation
If InitEngine3D() = 0
  MessageRequester( "Error" , "Can't initialize 3D, check if engine3D.dll is available" , 0 )
  End
ElseIf InitSprite() = 0 Or InitKeyboard() = 0 Or InitMouse() = 0
  MessageRequester( "Error" , "Can't find DirectX 7.0 or above" , 0 )
  End
EndIf

result = MessageRequester("Sun shader","Full Screen ?",#PB_MessageRequester_YesNo)
If result = 6     
  FullScreen=#True
  ExamineDesktops()
  OpenScreen(DesktopWidth(0),DesktopHeight(0),DesktopDepth(0),"Sun shader",#PB_Screen_SmartSynchronization,DesktopFrequency(0))
Else           
  FullScreen=#False
  OpenWindow(0,0, 0, 800 , 600 ,"Sun shader",#PB_Window_ScreenCentered)
  OpenWindowedScreen(WindowID(0),0,0, 800 , 600,0,0,0,#PB_Screen_SmartSynchronization )
EndIf

;- Ressources
Add3DArchive("shaders\", #PB_3DArchive_FileSystem  )
Add3DArchive("textures\", #PB_3DArchive_FileSystem  )
Add3DArchive("meshes\", #PB_3DArchive_FileSystem  )
Add3DArchive("materials\", #PB_3DArchive_FileSystem  )


;- Mesh
Parse3DScripts()
LoadMesh   (1 , "sun.mesh")
CreateEntity(1,   MeshID(1),  #PB_Material_None,0,0,0)

;- Add a light corona around the sun
LoadTexture(1,"corona.png")
CreateMaterial(1,TextureID(1))
DisableMaterialLighting(1, #True)
MaterialBlendingMode(1, 2) 
CreateBillboardGroup(1,MaterialID(1),5,5)
AddBillboard(1,1,0,0,0)


;- Light
CreateLight(1,$FFFFEE)

;- Camera
CreateCamera(0, 0,0,100,100)
CameraLocate(0, 0, 0, -5)
CameraLookAt(0, 0 , 0, 0)


Repeat

  If FullScreen = #False
    While WindowEvent():Wend
  EndIf
  ExamineKeyboard()
  ExamineMouse()
  movez = MouseWheel()
  If movez <> 0
    MoveCamera(0,0,0,movez / 5)
  EndIf
  
  ; Corona flickers
  RotateMaterial(1,Random(30)/1000,#PB_Material_Fixed)
  ResizeBillboard(0,1,5+Random(100)/1000,5+Random(100)/1000)
  
  RenderWorld()
  FlipBuffers()
  
  If KeyboardReleased(#PB_Key_F1)
    MessageRequester("FPS",StrF(Engine3DFrameRate(#PB_Engine3D_Average)) )
  EndIf
  
  ; Test: Peut-on refaire un second "Parse3DScripts" pour prendre en compte de nouveaux matriaux ?
  If KeyboardReleased(#PB_Key_Return)
    FreeEntity(1)
    FreeMesh(1)
    
    ; On intervertit les fichiers "sun.material" (il y en a un orange et un bleu)
    RenameFile("materials\sun.material","materials\tempsun.BAKmaterial")
    RenameFile("materials\sun.BAKmaterial","materials\sun.material")
    RenameFile("materials\tempsun.BAKmaterial","materials\sun.BAKmaterial")
    
    ; Et on essaye de recharger le tout
    Parse3DScripts()
    LoadMesh   (1, "sun.mesh")
    CreateEntity(1,   MeshID(1),  #PB_Material_None,0,0,0)
    
    ; Et a ne marche pas :( Dommage...
  EndIf
  
  Until KeyboardPushed(#PB_Key_Escape)

End

; IDE Options = PureBasic 4.51 (Windows - x86)
; CursorPosition = 40
; FirstLine = 18
; Executable = C:\0\fire.exe