/******************************************************************************
 This shader is a modified/simplified version of a lava shader by 
 Sergey A. Makovkin (sergeymak@pisem.net) and hg
******************************************************************************/

// Matrices
float4x4 WorldInverseTranspose : WorldInverseTranspose ;
float4x4 WorldViewProjection : WorldViewProjection ;
float4x4 World : World ;
float4x4 ViewInverse : ViewInverse ;

float Time : TIME ;

/* data passed from vertex shader to pixel shader */
struct vertexOutput {
    float4 HPosition	: POSITION;
    float4 TexCoord	: TEXCOORD0;    
    float3 WorldNormal	: TEXCOORD2;
    float3 WorldPos	: TEXCOORD3;
    float3 WorldEyePos	: TEXCOORD4;
};

/*********** vertex shader ******/
void sunVS(in float3 _Position	: POSITION,
            in float4 _UV		: TEXCOORD0,
            in float4 _Normal	: NORMAL,
            out vertexOutput OUT,
            uniform float4x4 WorldViewProjection,
            uniform float4x4 WorldInverseTranspose,
            uniform float4x4 World,
            uniform float4x4 ViewInverse
            ) 
{
    // vertexOutput OUT;
    OUT.WorldNormal = mul(WorldInverseTranspose,_Normal ).xyz;
    float3 WorldSpacePos = mul(World,float4(_Position, 1) ).xyz;
    OUT.WorldPos = WorldSpacePos;
    OUT.TexCoord = _UV;
    OUT.WorldEyePos = ViewInverse[3].xyz;
    OUT.HPosition = mul(WorldViewProjection,float4(_Position, 1) );
    //return OUT;
}

/*********** pixel shader ******/
void sunPS(in vertexOutput IN,
                out float4 _colour : COLOR0,
                      uniform float Time,
                      uniform float4 sunColor1,
                      uniform float4 sunColor2,
                      uniform float sunFactor,
                      uniform sampler2D NoiseSampler : TEXUNIT0
                      )
{
    	
	float rnd = 0.0f;
	float f = 1;
	float3 Coord = IN.WorldPos;
	//float3 Coord = IN.TexCoord;
	
	Coord.x += (Time * .02f);
	//Coord.y += (Time * .02f);

	for (int i = 0; i < 4; i++)
	{
		half fnoise = tex2D(NoiseSampler, Coord * .2f * f).r;

		fnoise -=.5f;
		fnoise *= 4.0f;
		rnd += ( fnoise) / f;
		f *= 4.17;	
	}
	    
	float3 coord = IN.WorldPos;
	coord.x += rnd*sunFactor;
	//coord.y += rnd*sunFactor;
	float4 tex = tex2D(NoiseSampler, coord).r;
				
	// Add the terms
	_colour = tex * sunColor1 + (1.0 - tex) * sunColor2;    

}

